<?php
/**
* 2007-2022 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2022 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class WiserNotify extends Module
{
    public $id_group_shop;
    public $id_shop;
    public function __construct()
    {
        $this->name = 'wisernotify';
        $this->tab = 'front_office_features';
        $this->version = '1.1.1';
        $this->author = 'WiserNotify';
        $this->need_instance = 0;
        $this->bootstrap = true;
        $this->module_key = 'b29b1984270b757b4dff3287d78db6db';
        parent::__construct();

        $this->displayName  = $this->l('Wiser Notify');
        $this->description  = $this->l('Build Trust, Create Urgency & Make Conversions Easier using WiserNotify social proof & FOMO extension.');
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);

        $this->id_group_shop = (int)Shop::getContextShopGroupID();
        $this->id_shop = (int)$this->context->shop->id;
    }

    public function install()
    {
        $this->createDefaultData();

        return parent::install()
            // && $this->registerHook('displayCookiesText')
            && $this->registerHook('displayAfterBodyOpeningTag')
            && $this->registerHook('displayOrderConfirmation')
            && $this->registerHook('displayHeader');
    }

    public function createDefaultData()
    {
        $this->createVariable();
    }

    public function createVariable()
    {
        $result = array();
        $languages = Language::getLanguages(false);
		//$result['WISERNOTIFY_TITLE']='';
        Configuration::updateValue('WISERNOTIFY_IMG', 'logo.gif');
        Configuration::updateValue(
            'WISERNOTIFY_TITLE',
            //$result['WISERNOTIFY_TITLE'],
            true
        );

        Configuration::updateValue('WISERNOTIFY_LINK', '#');
        Configuration::updateValue('WISERNOTIFY_API_KEY', '');
        Configuration::updateValue('WISERNOTIFY_API_STATUS', '0');
        Configuration::updateValue('WISERNOTIFY_API_SEND_FIRST30_ORDER', '0');
    }

    public function uninstall()
    {
        $this->deleteDefaultData();
        return parent::uninstall();
    }

    public function deleteDefaultData()
    {
        $this->deleteVariable();
    }

    public function deleteVariable()
    {
        Configuration::deleteByName('WISERNOTIFY_TITLE');
        Configuration::deleteByName('WISERNOTIFY_SUB_TITLE');
        Configuration::deleteByName('WISERNOTIFY_LINK');
        Configuration::deleteByName('WISERNOTIFY_API_KEY');
        Configuration::deleteByName('WISERNOTIFY_API_STATUS');
        Configuration::deleteByName('WISERNOTIFY_API_TI');
        Configuration::deleteByName('WISERNOTIFY_API_PT');
        Configuration::deleteByName('WISERNOTIFY_API_SEND_FIRST30_ORDER');
    }


    public function showAdminData()
    {
        $path = _MODULE_DIR_.$this->name."/views/img/";
        $this->context->smarty->assign('path', $path);

        $output = $this->randerForm();
        return $output;
    }

    public function imageUpload($img_file, $old_img = '')
    {
        $result = array();
        $result['error'] = false;
        $result['success'] = false;
        $result['img_name'] = $img_file['name'];
        $img_name = $img_file['name'];

        $allow_files_type = array('image/jpeg', 'image/jpg', 'image/png', 'image/gif');
        $path = _PS_MODULE_DIR_.$this->name."/views/img/";

        if (in_array($img_file['type'], $allow_files_type)) {
            $extension = explode('.', $img_name);
            $img_name = date("YmdHis").'.'.end($extension);

            $resultUpload = move_uploaded_file($img_file['tmp_name'], $path.$img_name);

            if ($resultUpload) {
                // $image_server = $path.$img_name;
                // $image_local = _PS_TMP_IMG_DIR_.$img_name;
                // copy($image_server, $image_local);
                // chmod($image_local, 0755);
                $result['success'] = true;
                $result['img_name'] = $img_name;
                $res = preg_match('/^uk_img_*/', $old_img);
                if (!empty($old_img)
                    && file_exists($path.$old_img)
                    && $res != '1'
                    ) {
                    @unlink($path.$old_img);
                }
            } else {
                $result['error'] .= $this->displayError($this->l("Image Upload Problem"));
            }
        } else {
            $result['error'] = $this->displayError($this->l("Please Select an Image File."));
        }

        return $result;
    }

    public function getContent()
    {
        $output = $this->postProcess()
            .$this->showAdminData();
        return $output;
    }

    public function postProcess()
    {
        $languages = Language::getLanguages(false);
        $result  = array();
        $messages = '';

        if (Tools::getValue('submitRecordFormDetails')) {
            $insert_data = array();
            if (!empty($_FILES['WISERNOTIFY_IMG'])) {
                $old_image_name = Configuration::get('WISERNOTIFY_IMG');
                $img_file = $_FILES['WISERNOTIFY_IMG'];
                $res = $this->imageUpload($img_file, $old_image_name);
                if ($res['success']) {
                    $insert_data['image'] = $res['img_name'];
                    Configuration::updateValue('WISERNOTIFY_IMG', $res['img_name']);
                } else {
                    $messages .= $res['error'];
                }
            }

            foreach ($languages as $lang) {
                $tmp = Tools::getValue('WISERNOTIFY_TITLE_'.$lang['id_lang']);
                $result['WISERNOTIFY_TITLE'][$lang['id_lang']] = $tmp;
            }

            Configuration::updateValue(
                'WISERNOTIFY_TITLE',
                $result['WISERNOTIFY_TITLE'],
                true
            );

            $tmp = Tools::getValue('WISERNOTIFY_LINK');
            Configuration::updateValue('WISERNOTIFY_LINK', $tmp);



            $ch = curl_init('https://is.wisernotify.com/api/prestashop/verifyAPI');
            // $resJson['ak'] = '37TW6ZJ-WAN4CD3-K68HJVH-14HRX5Y';
            $resJson = array();
            $resJson['ak'] = Tools::getValue('WISERNOTIFY_API_KEY');
            $resJson['ht'] = Configuration::get('PS_SHOP_DOMAIN');
            $resJson['status'] = "1";
            $resJson['fa'] = "edd";

            //$resJson = Tools::jsonEncode($resJson);
            $resJson = json_encode($resJson);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $resJson);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type:  application/json"));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $new_result = curl_exec($ch);
            // ob_flush();
            // flush();
            sleep(2);
            curl_close($ch);
            // ob_end_flush();
            //$new_result = Tools::jsonDecode($new_result);
            $new_result = json_decode($new_result);

            if ($new_result->msg == 1) {
                $tmp = Tools::getValue('WISERNOTIFY_API_KEY');
                Configuration::updateValue('WISERNOTIFY_API_KEY', $tmp);

                $tmp = Tools::getValue('WISERNOTIFY_API_STATUS');
                Configuration::updateValue('WISERNOTIFY_API_STATUS', $tmp);

                Configuration::updateValue('WISERNOTIFY_API_TI', $new_result->ti);

                $tmp = Tools::htmlentitiesUTF8($new_result->pt);
                Configuration::updateValue('WISERNOTIFY_API_PT', $tmp, true);
                $messages .= $this->displayConfirmation($this->l($new_result->str));

                if (Configuration::get('WISERNOTIFY_API_SEND_FIRST30_ORDER') == '0') {
                    $getOrders = Order::getOrdersWithInformations(30);
                    $prodDetails = array();
                    $i = 0;
                    foreach ($getOrders as $order) {
                        $orderObj = new Order($order['id_order']);
                        $id_customer = $orderObj->id_customer;
                        $custObj = new Customer($id_customer);
                        $addressObj = new Address($orderObj->id_address_delivery);

                        $custName = $custObj->firstname.' '.$custObj->lastname;
                        $email = $custObj->email;
                        $city = $addressObj->city;
                        $state = State::getNameById($addressObj->id_state);
                        $country = $addressObj->country;
                        // $ipaddress = "";
                        $domain = Configuration::get('PS_SHOP_DOMAIN');
                        $id_order = $order['id_order'];
                        $order_insert_date = Tools::strReplaceFirst(' ', 'T', $orderObj->date_add);

                        $productDetails = $orderObj->getProducts();
                        foreach ($productDetails as $prod) {
                            $id_product = $prod['id_product'];
                            $prodObj = new Product($id_product);
                            $prod_name = $prod['product_name'];

                            $id_image = Image::getCover($prod['id_product']);
                            $product_link = $this->context->link->getProductLink($prodObj);
                            $imagePath = $this->context->link->getImageLink(
                                $prodObj->link_rewrite[$this->context->language->id],
                                $id_image['id_image'],
                                ImageType::getFormattedName('large')
                            );

                            $prodDetails[$i]['un'] = $custName;
                            $prodDetails[$i]['e'] = $email;
                            $prodDetails[$i]['ct'] = $city;
                            $prodDetails[$i]['st'] = $state;
                            $prodDetails[$i]['cn'] = $country;
                            $prodDetails[$i]['i'] = "";
                            $prodDetails[$i]['ht'] = $domain;
                            $prodDetails[$i]['oid'] = $id_order;
                            $prodDetails[$i]['insdt'] = $order_insert_date;
                            $prodDetails[$i]['pn'] = $prod_name;
                            $prodDetails[$i]['pu'] = $product_link;
                            $prodDetails[$i]['piu'] = $imagePath;
                            $i++;
                        }
                    }
                  //  $prodDetails = Tools::jsonEncode($prodDetails);
                    $prodDetails = json_encode($prodDetails);
                    $ch = curl_init('https://is.wisernotify.com/api/prestashop/data');
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $prodDetails);
                    curl_setopt(
                        $ch,
                        CURLOPT_HTTPHEADER,
                        array(
                            "ak:".Configuration::get('WISERNOTIFY_API_KEY')."",
                            "ti:".Configuration::get('WISERNOTIFY_API_TI')."",
                            "Content-Type:  application/json"
                        )
                    );
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $new_result = curl_exec($ch);
                    // ob_flush();
                    // flush();
                    sleep(2);
                    curl_close($ch);
                    // ob_end_flush();
                   // $new_result = Tools::jsonDecode($new_result);
                   $new_result = json_decode($new_result);

                    // print_r($new_result);
                    // die;
                    if ($new_result->status !== null && $new_result->status == 'success') {
                    }
                    Configuration::updateValue('WISERNOTIFY_API_SEND_FIRST30_ORDER', '1');
                }
            } else {
                $messages .= $this->displayError($this->l($new_result->str));
            }
        }

        return $messages;
    }

    public function randerForm()
    {
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $tmp = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        $helper->allow_employee_form_lang = $tmp ? $tmp : 0;
        $helper->identifier = $this->identifier;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).
            '&configure='.$this->name.
            '&tab_module='.$this->tab.
            '&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        $form = array();
        $form[] = $this->recordFormDetails();

        return $helper->generateForm($form);
    }

    public function recordFormDetails()
    {
        $fields_form = array();
        // Record Data Information
        $input = array();


        // $input[] = array(
        //             'type' => 'img_file',
        //             'label' => $this->l('Image'),
        //             'name' => 'WISERNOTIFY_IMG',
        //         );


        // $input[] = array(
        //             'type' => 'textarea',
        //             'label' => $this->l('Title'),
        //             'name' => 'WISERNOTIFY_TITLE',
        //             'lang' => true,
        //             'cols' => 40,
        //             'rows' => 10,
        //             'class' => 'rte',
        //             'autoload_rte' => true,
        //         );

        // $input[] = array(
        //             'type' => 'text',
        //             'label' => $this->l('Link'),
        //             'name' => 'WISERNOTIFY_LINK',
        //         );

        $input[] = array(
                    'type' => 'text',
                    'label' => $this->l('API Key'),
                    'name' => 'WISERNOTIFY_API_KEY',
                );

        $input[] = array(
                    'type' => 'switch',
                    'label' => $this->l('Status'),
                    'name' => 'WISERNOTIFY_API_STATUS',
                    'is_bool' => true,
                    'desc' => $this->l('Keep this option ON while submitting the API key. It works only if this option is ON'),
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    ),
                );

        $fields_form['form'] = array(
            'tinymce' => true,
            'legend' => array(
                'title' => $this->l('Record Data'),
            ),
            'input' => $input,
            'submit' => array(
                'title' => $this->l('Save'),
                'name' => 'submitRecordFormDetails',
                'class' => 'btn btn-default pull-right'
            )
        );

        return $fields_form;
    }


    public function getConfigFieldsValues()
    {
        $result = array();
        $languages = Language::getLanguages(false);

        foreach ($languages as $lang) {
            $tmp = Configuration::get('WISERNOTIFY_TITLE', $lang['id_lang'], true);
            $result['WISERNOTIFY_TITLE'][$lang['id_lang']] = $tmp;
        }

        $tmp = Configuration::get('WISERNOTIFY_IMG');
        $result['WISERNOTIFY_IMG'] = $tmp;

        $tmp = Configuration::get('WISERNOTIFY_LINK');
        $result['WISERNOTIFY_LINK'] = $tmp;

        $tmp = Configuration::get('WISERNOTIFY_API_KEY');
        $result['WISERNOTIFY_API_KEY'] = $tmp;

        $tmp = Configuration::get('WISERNOTIFY_API_STATUS');
        $result['WISERNOTIFY_API_STATUS'] = $tmp;

        return $result;
    }

    public function hookdisplayHeader()
    {
        $this->context->controller->addJS($this->_path.'views/js/front.js');
        $this->context->controller->addCSS($this->_path.'views/css/front.css');
    }

    public function getFrontSideData()
    {
        $context = Context::getContext();
        $id_lang = $context->cookie->id_lang;

        $arr_data = array();
        $tmp = Configuration::get('WISERNOTIFY_IMG', $id_lang);
        $arr_data['image'] = $tmp;

        $tmp = Configuration::get('WISERNOTIFY_TITLE', $id_lang, true);
        $arr_data['title'] = $tmp;

        $tmp = Configuration::get('WISERNOTIFY_LINK', $id_lang);
        $arr_data['link'] = $tmp;

        return $arr_data;
    }

    public function hookdisplayCookiesText()
    {
        return $this->hookdisplayHome();
    }

    public function hookdisplayAfterBodyOpeningTag()
    {
        $output = '';
        $script_data = Tools::htmlentitiesDecodeUTF8(Configuration::get('WISERNOTIFY_API_PT', true));
        $this->context->smarty->assign('script_data', $script_data);
        $output = $this->display(__FILE__, 'views/templates/hook/display_home.tpl');
        return $output;
    }

    public function hookdisplayOrderConfirmation($params)
    {
        $order = $params['order'];
        $id_order = $order->id;
        $orderObj = new Order($id_order);
        $id_customer = $orderObj->id_customer;
        $custObj = new Customer($id_customer);
        $addressObj = new Address($orderObj->id_address_delivery);

        $custName = $custObj->firstname.' '.$custObj->lastname;
        $email = $custObj->email;
        $city = $addressObj->city;
        $state = State::getNameById($addressObj->id_state);
        $country = $addressObj->country;
        // $ipaddress = "";
        $domain = Configuration::get('PS_SHOP_DOMAIN');
        $order_insert_date = Tools::strReplaceFirst(' ', 'T', $orderObj->date_add);

        $productDetails = $orderObj->getProducts();
        $prodDetails = array();
        $i = 0;
        foreach ($productDetails as $prod) {
            $id_product = $prod['id_product'];
            $prodObj = new Product($id_product);
            $prod_name = $prod['product_name'];

            $id_image = Image::getCover($prod['id_product']);
            $product_link = $this->context->link->getProductLink($prodObj);
            $imagePath = $this->context->link->getImageLink(
                $prodObj->link_rewrite[$this->context->language->id],
                $id_image['id_image'],
                ImageType::getFormattedName('large')
            );

            $prodDetails[$i]['un'] = $custName;
            $prodDetails[$i]['e'] = $email;
            $prodDetails[$i]['ct'] = $city;
            $prodDetails[$i]['st'] = $state;
            $prodDetails[$i]['cn'] = $country;
            $prodDetails[$i]['i'] = "";
            $prodDetails[$i]['ht'] = $domain;
            $prodDetails[$i]['oid'] = $id_order;
            $prodDetails[$i]['insdt'] = $order_insert_date;
            $prodDetails[$i]['pn'] = $prod_name;
            $prodDetails[$i]['pu'] = $product_link;
            $prodDetails[$i]['piu'] = $imagePath;
            $i++;
        }
      //  $prodDetails = Tools::jsonEncode($prodDetails);
      $prodDetails = json_encode($prodDetails);

        $ch = curl_init('https://is.wisernotify.com/api/prestashop/data');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $prodDetails);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                "ak:".Configuration::get('WISERNOTIFY_API_KEY')."",
                "ti:".Configuration::get('WISERNOTIFY_API_TI')."",
                "Content-Type:  application/json"
            )
        );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $new_result = curl_exec($ch);
        // ob_flush();
        // flush();
        sleep(2);
        curl_close($ch);
        // ob_end_flush();

        // if ($new_result->status !== null && $new_result->status == 'success') {

        // }

        return '';
    }
}
